/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.utils;

import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.logging.Logger;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.ws.utils.WSSchemaValidator;
import filenet.ws.utils.WSSchemaValidatorResult;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WSDLSchemaHelper
extends DefaultHandler {
    protected static Logger logger = Logger.getLogger("filenet.ws.utils");
    protected static final String m_className = "WSDLSchemaHelper";
    StringBuffer textBuffer = null;
    boolean okToWrite = false;
    boolean stopParsing = false;
    Vector namespaces = new Vector();
    Hashtable schemasMap = new Hashtable();
    StringBuffer schemaBuffer = null;
    String currentTNS = null;

    public String[] getSchemas() {
        int nSchemas = this.namespaces.size();
        String[] res = new String[nSchemas];
        for (int i = 0; i < nSchemas; ++i) {
            res[i] = (String)this.schemasMap.get(this.namespaces.get(i));
        }
        return res;
    }

    public String[] getNamespaces() {
        return this.namespaces.toArray(new String[0]);
    }

    protected Hashtable getSchemasMap() {
        return this.schemasMap;
    }

    public static WSDLSchemaHelper getSchemas(String uri) throws Throwable {
        String m_method = "getSchemas-URI";
        WSDLSchemaHelper handler = new WSDLSchemaHelper();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(uri, (DefaultHandler)handler);
        }
        catch (Throwable t) {
            logger.throwing(m_className, "getSchemas-URI", t);
            throw t;
        }
        return handler;
    }

    public static WSDLSchemaHelper getSchemas(byte[] wsdlContents) throws Throwable {
        String m_method = "getSchemas-ByteStream";
        WSDLSchemaHelper handler = new WSDLSchemaHelper();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse((InputStream)new ByteArrayInputStream(wsdlContents), (DefaultHandler)handler);
        }
        catch (Throwable t) {
            logger.throwing(m_className, "getSchemas-ByteStream", t);
            throw t;
        }
        return handler;
    }

    public static String mergeSchemas(String s1, String s2) throws Exception {
        if (s1 == null || s2 == null) {
            return null;
        }
        VWXMLWrapper xmlS1 = new VWXMLWrapper(s1);
        Node s1Node = xmlS1.getRootNode();
        if (!s1Node.getLocalName().equals("schema")) {
            throw new Exception("Expecting schema elements");
        }
        VWXMLWrapper xmlS2 = new VWXMLWrapper(s2);
        Node s2Node = xmlS2.getRootNode();
        if (!s2Node.getLocalName().equals("schema")) {
            throw new Exception("Expecting schema element.");
        }
        String s1TNS = s1Node.getAttributes().getNamedItem("targetNamespace").getNodeValue();
        String s2TNS = s2Node.getAttributes().getNamedItem("targetNamespace").getNodeValue();
        if (s1TNS == null || s2TNS == null) {
            throw new Exception("Missing targetNamespace attribute.");
        }
        if (!s1TNS.equals(s2TNS)) {
            throw new Exception("Mismatched targetNamespaces. " + s1TNS + "!=" + s2TNS);
        }
        NodeList nodeList = s2Node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                Node node1 = xmlS1.getDocument().importNode(node, true);
                s1Node.appendChild(node1);
            }
        }
        String res = xmlS1.toXML(s1Node);
        return res;
    }

    private static void printUsage() {
        System.out.println("Usage: WSDLSchemaHelper /nw=N /w1=... /w2=... .... /wN=...");
        System.out.println("            /ns=N /s1=... ... /sN=...");
        System.out.println("OR: WSDLSchemaHelper /inputfile=<inputfile>");
        System.exit(1);
    }

    private static String[] getParameters(VWCommandLineArgs c, String type, String typeDesc) throws Exception {
        String[] schemaFiles = null;
        int nSchemas = c.getIntParameter("n" + type, 0);
        if (nSchemas == 0) {
            String s = c.getParameter(type);
            if (s == null) {
                return null;
            }
            schemaFiles = new String[]{s};
        } else {
            schemaFiles = new String[nSchemas];
            for (int i = 1; i <= nSchemas; ++i) {
                String s;
                String paramName = type + Integer.toString(i);
                schemaFiles[i - 1] = s = c.getParameter(paramName);
                if (s != null) continue;
                throw new Exception("Missing " + paramName + " for " + typeDesc);
            }
        }
        return schemaFiles;
    }

    private static String[] getContentsFromFiles(String[] files, String typeDesc) throws Exception {
        if (files == null || files.length == 0) {
            throw new Exception("No " + typeDesc);
        }
        int nItems = files.length;
        String[] res = new String[nItems];
        for (int i = 0; i < nItems; ++i) {
            res[i] = new String(WSDLSchemaHelper.readFile(files[i]));
        }
        return res;
    }

    private static byte[] readFile(String fileName) throws Exception {
        File fileInfo = null;
        BufferedInputStream inStream = null;
        byte[] contents = null;
        try {
            fileInfo = new File(fileName);
            inStream = new BufferedInputStream(new FileInputStream(fileName));
            int len = (int)fileInfo.length();
            if (len > 0) {
                contents = new byte[len];
                inStream.read(contents, 0, len);
                inStream.close();
                inStream = null;
                byte[] byArray = contents;
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            inStream = null;
        }
    }

    public static void main(String[] argv) {
        try {
            String[] wsdlFiles;
            VWCommandLineArgs c = new VWCommandLineArgs(argv);
            String inputFile = c.getParameter("inputfile");
            if (inputFile != null) {
                c = new VWCommandLineArgs(inputFile, false);
            }
            if (c.isPresent("h")) {
                WSDLSchemaHelper.printUsage();
            }
            if ((wsdlFiles = WSDLSchemaHelper.getParameters(c, "w", "WSDL Files")) != null) {
                int nInstances = wsdlFiles.length;
                for (int i = 0; i < nInstances; ++i) {
                    WSDLSchemaHelper m = WSDLSchemaHelper.getSchemas(wsdlFiles[i]);
                    System.out.println("\n---------- " + wsdlFiles[i]);
                    String[] tnss = m.getNamespaces();
                    String[] schemas = m.getSchemas();
                    int nSchemas = schemas.length;
                    for (int j = 0; j < nSchemas; ++j) {
                        System.out.println("TNS=" + tnss[j]);
                        System.out.println("schema=" + schemas[j]);
                    }
                    System.out.println("\n----- Now to test if the schemas are valid...");
                    WSSchemaValidatorResult res = WSSchemaValidator.validate(tnss, null, schemas, null);
                    System.out.println("Result is " + res);
                }
            } else {
                System.out.println("No WSDL to get schemas ...");
            }
            String[] schemaFiles = WSDLSchemaHelper.getParameters(c, "s", "XML Schema");
            if (schemaFiles == null || schemaFiles.length == 1) {
                System.out.println("No Schemas to merge.. get out of here");
                return;
            }
            String[] schemaFileContents = WSDLSchemaHelper.getContentsFromFiles(schemaFiles, "XML Schema");
            int nSchemas = schemaFileContents.length;
            if (nSchemas == 1) {
                return;
            }
            String s = schemaFileContents[0];
            for (int j = 1; j < nSchemas; ++j) {
                s = WSDLSchemaHelper.mergeSchemas(s, schemaFileContents[j]);
                System.out.println("NEW SCHEMAS = ");
                System.out.println(s);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.exit(0);
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        if (this.stopParsing) {
            return;
        }
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (eName.indexOf("definitions") != -1 || eName.indexOf("types") != -1) {
            return;
        }
        if (eName.indexOf(":schema") != -1) {
            this.schemaBuffer = new StringBuffer();
        }
        this.emit("<" + eName);
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String aName = attrs.getLocalName(i);
                if ("".equals(aName)) {
                    aName = attrs.getQName(i);
                }
                if (aName.indexOf("targetNamespace") != -1) {
                    this.currentTNS = attrs.getValue(i);
                }
                this.emit(" ");
                this.emit(aName + "=\"" + attrs.getValue(i) + "\"");
            }
        }
        this.emit(">");
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (this.stopParsing) {
            return;
        }
        this.echoText();
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (eName.indexOf("types") != -1) {
            this.stopParsing = true;
            return;
        }
        this.emit("</" + eName + ">\n");
        if (eName.indexOf(":schema") != -1) {
            String s = this.schemaBuffer.toString();
            this.schemaBuffer = null;
            if (this.currentTNS != null) {
                String oldS = (String)this.schemasMap.get(this.currentTNS);
                if (oldS != null) {
                    try {
                        s = WSDLSchemaHelper.mergeSchemas(oldS, s);
                        this.schemasMap.remove(this.currentTNS);
                    }
                    catch (Exception e) {}
                } else {
                    this.namespaces.add(this.currentTNS);
                }
                this.schemasMap.put(this.currentTNS, s);
            }
            this.currentTNS = null;
        }
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len).trim();
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer(s);
        } else {
            this.textBuffer.append(s);
        }
    }

    private void echoText() throws SAXException {
        if (this.textBuffer == null) {
            return;
        }
        this.emit(this.textBuffer.toString());
        this.textBuffer = null;
    }

    private void emit(String s) {
        if (this.schemaBuffer == null) {
            return;
        }
        this.schemaBuffer.append(s);
    }
}

